/******************************************************************
/* [COMIDAS sample program by COMIZOA Inc., Ltd]
/*
/* - Subject : Unlimited Scan
/* - Contents: COMI-SD101 带 ̿Ͽ PID Control ϴ Դϴ.
/*           ֽϴ.
/*     1. A/D CH0    Feedback޴ äη Ѵ.
/*     2. D/A CH0   ۷ ΰϴ äη Ѵ.
/*     3. ۷ Է ⺻ Ķ͸ Ͽ Էµǵ Ǿ , 0V 4V 
/*         2  ۷ ȴ.  ܺο ۷ Է ְ Ѵٸ
/*        '#define REF_CH'  ϴ A/D äη ϸ ȴ. 
/*	   3.  ļ  '#define S_FREQ'   ϸ Default 500Hz Ǿ.
/*     4.  ۵Ǹ ۷   A/D ä  C:\COMIPID.TXT Ͽ ȴ.
/*     5.    ƹŰ  α׷ ȴ. 
/*
/* - Remarks : 
/*     1.   COMI-SD101, COMI-SD102, COMI-SD103  Ǵ Դϴ.    
/******************************************************************/

#include <windows.h>
#include <stdio.h>
#include <conio.h>
#include <mmsystem.h>
#include "Comidas.h"

#define DEV_ID	COMI_SD101
#define NUM_CH	3	/* Number of channels */
#define S_FREQ	500	/* Scan freq. -> 500 Hz */
#define MSB		40960	/* Max scans/buffer =>   scan  ũ⸦ ϴµ  */
						/* 1024  ϴ° .                           */

#define FEED_CH	 0  // -   Feedback޴ A/D ä 
#define DA_CH	 0  // -  ۷ ΰ D/A ä 
#define REF_CH	-1	// - ۷ ä : -1 ǹ̴ Ķͷ Ѱ  ۷ ϶ ǹ 
                    //    ̰   ϸ ش A/D ä  ܺο ۷ Է  ִ. 

#define LIMIT_H		10.f // Limiter high value - D/A  Limit
#define LIMIT_L		0.f  // Limiter low value  - D/A  Limit
#define Kp	5 
#define Td	0
#define Ti	0

#define ToggleValue(v, l, h) ((v==l) ? h: l)

#define MAX_RET_SIZE	1024   // Scan buffer ͸ ޹ ִ   ִ ũ //
float Buffer[MAX_RET_SIZE*NUM_CH];
void main (void)
{
	HANDLE hDevice;
	FILE *fp;
	ULONG prv_cnt, ret_count, prv_time, cur_time;
	TPidParams PidParams = {0.f, LIMIT_H, LIMIT_L, Kp, Td, Ti, REF_CH, DA_CH, FEED_CH};
	int ch_list[NUM_CH] = {0, 1, 2};  // A/D CH0   FEEDBACKϱ  ä̸,  CH1 CH2 
	                             //  뵵   ƴϸ, ڿ  ܺ ۷ Է Ǵ 
	                             // D/A ° ͸ϴ 뵵   ֽϴ. 

	if(DEV_ID != COMI_SD101 && DEV_ID){
		printf("PID Control COMI_SD101 忡 ˴ϴ. \n");
		printf("ƹŰ  α׷ ˴ϴ.. \n");
		_getch();
		exit(0);
	}
	
	/* Load DLL */
	if(!COMI_LoadDll()){
		printf("Comidas.dll load failure\n");
		printf("ƹŰ  α׷ ˴ϴ.. \n");
		_getch();
		exit(0);
	}
	/* Load Device */
	hDevice = COMI_LoadDevice (DEV_ID, 0);
	if(hDevice == INVALID_HANDLE_VALUE){
		printf("Can't load specified device!\n");
		printf("ƹŰ  α׷ ˴ϴ.. \n");
		_getch();
		COMI_UnloadDll();
		exit(0);
	}

	printf("PID  Ϸ ƹŰ ʽÿ.\n");
	printf("ƹŰ ٽ  α׷ ˴ϴ.\n");
	_getch();
	
	COMI_PID_Enable(hDevice);
	COMI_PID_SetParams (hDevice, 1, &PidParams); // PID_SetParams(..) Լ ݵ PID_Enable(..)Լ 
	                                            // Ŀ ׸ PID_Disable()Լ  Ǿ Ѵ.
	/* start unlimited scan */
	long act_freq = COMI_US_Start (hDevice, NUM_CH, ch_list, S_FREQ, MSB, TRS_SINGLE);
	if(act_freq < 0){
		/* Error ó */
		printf("Error : Failed to start unlimited scan!");
		printf("%s", COMI_ErrorString(COMI_LastError())); 
		COMI_UnloadDevice(hDevice);
		COMI_UnloadDll();
		printf("ƹŰ  α׷ ˴ϴ.. \n");
		_getch();
		exit(0);
	}

	prv_time = timeGetTime();
	/* Create a file to save data */
	fp = fopen ("c:\\ComiPID.txt", "w");
	fprintf (fp,"  Refer      CH0      CH1      CH2\n");
	printf("Unlimited scan has started !!\nPress any key to quit\n");

	prv_cnt = 0L; // initialize count variable
	while(!kbhit())
	{
		//  2ʸ ۷  ٲپ ޽  ۷ Է ǵ Ѵ. //
		//  ܺ ۷ Է  쿡   ǹϴ.    //
		cur_time = timeGetTime();
		if(cur_time - prv_time > 1000 ){
			PidParams.Ref = ToggleValue(PidParams.Ref, 0.f, 4.f);
			COMI_PID_SetParams (hDevice, 1, &PidParams);
			prv_time = cur_time;
		}
		
		//  Ͽ Ѵ. //
		ret_count = COMI_US_RetrvBlock (hDevice, prv_cnt+1, MAX_RET_SIZE, Buffer, VT_FLOAT);	
		for(ULONG i=0; i<ret_count; i++)
		{
			fprintf(fp, "%7.2f %8.3f %8.3f %8.3f\n", PidParams.Ref, Buffer[i*NUM_CH], 
					Buffer[i*NUM_CH+1], Buffer[i*NUM_CH+2]);
		}
		prv_cnt = prv_cnt + ret_count;
		printf("Reference = %6.2f   Number of saved data = %u\n", PidParams.Ref, prv_cnt);
	}
	
	COMI_US_Stop (hDevice, TRUE);
	COMI_PID_Disable(hDevice);
	fclose(fp);

	COMI_UnloadDevice(hDevice);
	COMI_UnloadDll();
}
